<?php
    /*
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */
?>

    <form name="formAggiornamentoImpostazioniRegistrazione" action="../controller/controllerImpostazioni.php" method="post">
        <input type="text" class="d-none" name="operazione" value="aggiornaImpostazioniRegistrazione">
        <h4 class="mb-4 title">Registrazione utenti</h4>

        <div class="row mt-5">
            <div class="col-xl-4">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Consenti registrazioni </label>
                    <input type="checkbox" id="registrazioneUtenti" name="registrazioneUtenti" class="js-switch" value="si" <?php echo(($impostazioni["registrazioneUtenti"]=="si") ? "checked" : "") ?> />
                    <small class="d-block text-muted">Se disattivato gli utenti non potranno registrarsi alla piattaforma</small>
                </div>
            </div>
            
            <div class="col-xl-4">
                <div class="form-group">
                    <label for="descrizione">Gruppo dei nuovi registrati</label>
                    <select name=gruppoDefault class="form-control">
                        <option value="0" >Nessuno</option>
                        <?php
                            $queryComponentiDaMostrare = "SELECT * FROM geec_gruppi";
                            $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);  
                            while($gruppo = $risComponenti->fetch_assoc()) {
                                $selezionato = "";
                                if($impostazioni["gruppoDefault"]==$gruppo["id"]) {
                                    $selezionato = "selected";
                                }
                                echo"<option value=\"{$gruppo["id"]}\" $selezionato >{$gruppo["nome"]}</option>";
                            }
                        ?>
                    </select>
                    <small class="text-muted">Puoi decidere un gruppo per gli utenti appena registrati</small>
                </div>
            </div>

            <div class="col-xl-4">
                <div class="form-group">
                    <label for="descrizione">Stato iniziale nuovi utenti</label>
                    <select name="statoInizialeNuoviUtenti" class="form-control">
                        <?php
                            $statiPossibili = array("attivato","non attivato");
                            foreach($statiPossibili as $stato) {
                                $selezionato = ($impostazioni["statoInizialeNuoviUtenti"]==$stato) ? "selected" : "";
                                echo"<option value=\"{$stato}\" $selezionato >{$stato}</option>";
                            }
                        ?>
                    </select>
                    <small class="text-muted">L'utente non potrà accedere all'area amministrativa se non attivato</small>
                </div>
            </div>
            
            <div class="col-xl-4">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Accesso con Facebook </label>
                    <input type="checkbox" name=accessoFacebook class="js-switch" value="si" <?php echo(($impostazioni["accessoFacebook"]=="si") ? "checked" : "") ?> />
                    <small class="d-block text-muted">Consenti l'accesso con account Facebook</small>
                </div>
            </div>
            
            <div class="col-xl-4">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Accesso con Google </label>
                    <input type="checkbox" name=accessoGoogle class="js-switch" value="si" <?php echo(($impostazioni["accessoGoogle"]=="si") ? "checked" : "") ?> />
                    <small class="d-block text-muted">Consenti l'accesso con account Google</small>
                </div>
            </div>
        </div>
        
        <div class="row mt-5">
            <div class="col-12">
                <h5>Modulo registrazione</h5>
                <hr>
            </div>

            <div class="col-xl-3">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Richiedi email </label>
                    <input type="checkbox" id="richiediEmail" name=richiediEmail class="js-switch" value="si" <?php echo(($moduloRegistrazione["richiediEmail"]=="si") ? "checked" : "") ?> />
                </div>
            </div>
            
            <div class="col-xl-3">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Richiedi password </label>
                    <input type="checkbox" id="richiediPassword" name="richiediPassword" class="js-switch" value="si" <?php echo(($moduloRegistrazione["richiediPassword"]=="si") ? "checked" : "") ?> />
                </div>
            </div>
            
            <div class="w-100"></div>
            
            <div class="col-xl-3">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Richiedi nome </label>
                    <input type="checkbox" id="richiediNome" name="richiediNome" class="js-switch" value="si" <?php echo(($moduloRegistrazione["richiediNome"]=="si") ? "checked" : "") ?>/>
                </div>
            </div>
            
            <div class="col-xl-3">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Richiedi cognome </label>
                    <input type="checkbox" id="richiediCognome" name=richiediCognome class="js-switch" value="si" <?php echo(($moduloRegistrazione["richiediCognome"]=="si") ? "checked" : "") ?> />
                </div>
            </div>
            
            <div class="col-xl-3">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Richiedi codice fiscale </label>
                    <input type="checkbox" id="richiediCodiceFiscale" name="richiediCodiceFiscale" class="js-switch" value="si" <?php echo(($moduloRegistrazione["richiediCodiceFiscale"]=="si") ? "checked" : "") ?>/>
                </div>
            </div>
            
            <div class="col-xl-3">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Richiedi partita IVA </label>
                    <input type="checkbox" id="richiediPartitaIva" name=richiediPartitaIva class="js-switch" value="si" <?php echo(($moduloRegistrazione["richiediPartitaIva"]=="si") ? "checked" : "") ?> />
                </div>
            </div>
            
            <div class="w-100"></div>

            <div class="col-xl-3">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Richiedi organizzazione </label>
                    <input type="checkbox" id="richiediOrganizzazione" name="richiediOrganizzazione" class="js-switch" value="si" <?php echo(($moduloRegistrazione["richiediOrganizzazione"]=="si") ? "checked" : "") ?> />
                </div>
            </div>
                        
            <div class="col-xl-3">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Richiedi città </label>
                    <input type="checkbox" id="richiediCitta" name="richiediCitta" class="js-switch" value="si" <?php echo(($moduloRegistrazione["richiediCitta"]=="si") ? "checked" : "") ?>/>
                </div>
            </div>
            
            <div class="col-xl-3">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Richiedi telefono </label>
                    <input type="checkbox" id="richiediTelefono" name=richiediTelefono class="js-switch" value="si" <?php echo(($moduloRegistrazione["richiediTelefono"]=="si") ? "checked" : "") ?> />
                </div>
            </div>

            <div class="w-100"></div>
            
            <div class="col-xl-3">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Richiedi gruppo </label>
                    <input type="checkbox" name="richiediGruppo" class="js-switch" value="si" <?php echo(($moduloRegistrazione["richiediGruppo"]=="si") ? "checked" : "") ?> />
                    <small class="d-block text-muted">L'utente avrà la possibilità di selezionare il gruppo in cui verrà inserito</small>
                </div>
            </div>

            <div class="col-xl-3">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Gruppo obbligatorio</label>
                    <input type="checkbox" name="gruppoObbligatorio" class="js-switch" value="si" <?php echo(($moduloRegistrazione["gruppoObbligatorio"]=="si") ? "checked" : "") ?> />
                    <small class="d-block text-muted">Se selezionato, l'utente dovrà selezionare obbligatoriamente un gruppo per registrarsi</small>
                </div>
            </div>
        </div>
        
        <div class="row mt-5">
            <div class="col-12">
                <h5>Email di conferma</h5>
                <hr>
            </div>
            
            <div class="col-xl-4">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Invia mail di conferma </label>
                    <input type="checkbox" name=inviaMailConferma class="js-switch" value="si" <?php echo(($moduloRegistrazione["inviaMailConferma"]=="si") ? "checked" : "") ?> />
                    <small class="d-block text-muted">L'utente riceverà una mail di conferma di avvenuta registrazione</small>
                </div>
            </div>
            
            <div class="col-xl-4">
                <div class="form-group">
                    <label for="descrizione" class="d-block">Invia password via mail</label>
                    <input type="checkbox" name=inviaPasswordViaEmail class="js-switch" value="si" <?php echo(($moduloRegistrazione["inviaPasswordViaEmail"]=="si") ? "checked" : "") ?> />
                    <small class="d-block text-muted">L'utente riceverà la password nella mail di conferma.</small>
                </div>
            </div>
            
            <div class="col-12">
                <textarea id="contenutoEmailRegistrazione" name="contenutoEmailRegistrazione" class="tiny"><?php echo $moduloRegistrazione["contenutoEmailRegistrazione"] ?></textarea>
                <small class="text-muted">Personalizza il contenuto dell'email inviata all'utente appena registrato</small>
            </div>
            
            <div class="col-12">
                <button type="button" class="btn btn-primary float-right" onclick="inviaImpostazioniRegistrazione()"><i class="fas fa-check"></i> Salva</button>
            </div><!--/usa questo markup se ti serve un salvataggio di una singola sezione-->
        </div>
    </form>